//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Global Functions
//:
//: ## Task:
//:
//: Functions can exist by themselves (globally), or be confined within a `Type` or exist inside another function (as a nested function).
//:
//: Execute the run point below. The code declares a global function that exists within the scope of the whole program. The function is defined but never called. No code will execute.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func printHappyFaces() {
    print("🙂")
    print("😀")
    print("😃")
}


//:
//: -------------------
//:
//: To execute this function we must write its name followed by brackets `()`.
//:
//: Execute the code below. The code within the function will execute once.
//:
//: -------------------
//:


printHappyFaces()


//:
//: -------------------
//:
//: We can execute the code contained in this function as many times as we need.
//:
//: Execute the run point below. The function is called 4 times. The code within the function will execute 4 times.
//:
//: -------------------
//:


printHappyFaces()
printHappyFaces()
printHappyFaces()
printHappyFaces()


//:
//: -------------------
//:
//: ## Task:
//:
//: Functions can be confined within a `Type`.
//:
//: This is a common use of functions as it creates architecture and a well defined scope to operate in.
//:
//: In the code area below, declare a struct and write a new but identical `printHappyFaces` function inside. Name your struct `HappyFacePrinter`.
//:
//: Create a new instance of your struct and execute the function on the instance (an instance function also known as an instance method).
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Inside the instance method (a method is a function when located inside a type) write a nested function (a function inside your function) that will peform the printing based on a `String` input parameter to be used as each happy face character.
//:
//: Execute this function.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Now declare a new global function which will create a new instance of your `HappyFacePrinter` struct and execute it once.
//:
//: Execute this function.
//:
//: Your code should now execute a global function, which executes an instance method, which executes a nested function. 🎉
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: The types in Swift already contain many functions (instance methods, type methods and also properties).
//:
//: Confining each function to a type helps a lot to place context when reading the code and creates very helpful architecture.
//:
//: Execute the code below. What does it do?
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


let diceRoll = Int.random(in: 1...6)
print(diceRoll == 6 ? "You win!" : "You lose.")
// Run here

let diceRoll2 = Double.random(in: 1...6)
print(diceRoll2 == 6 ? "You win!" : "You lose.")
// Run here

let diceRoll3 = Bool.random()
print(diceRoll3 == true ? "You win!" : "You lose.")
// Run here

if let character = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".randomElement() {
    print(character)
}
// Run here


//:
//: -------------------
//:
//: ## Task:
//:
//: Use the code area below to experiment with an instance or type method you have never used before.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:

// count
let alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
if alphabet.count == 26 {
    print("We have 26 characters")
}

// hashValue
print(alphabet.hashValue) // generates a unique code that'll match when the values are the same

let alphabet2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
if alphabet.hashValue == alphabet2.hashValue {
    print("Both strings contain matching content. The data is identical")
}

var hundred = 100
print(hundred.hashValue)

// negate
hundred.negate()
print(hundred)
hundred.negate()
print(hundred)


// now its your turn. Execute an instance or type method here


//:
//: -------------------
//:
//: ## Task:
//:
//: A type method is a function that exists within the type itself (Not an instance of a type).
//:
//: Execute a type method you have never used before.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// type methods
Int.random(in: 1...6)
Double.random(in: 1...6)
Bool.random()

// instance methods
"ABCDEFGHIJKLMNOPQRSTUVWXYZ".lowercased()
"ABCDEFGHIJKLMNOPQRSTUVWXYZ".min()
"ABCDEFGHIJKLMNOPQRSTUVWXYZ".max()


// now its your turn. Execute a type method here

